#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
    /// </summary>
    [Description("%b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. ")]
    public class BollingerPercentB : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 20; // Default setting for Period
            private double standardDev = 2; // Default setting for StandardDev
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
           
			Add(new Plot(new Pen(Color.Navy, 2), PlotStyle.Bar, "PctB"));
            Add(new Line(Color.FromKnownColor(KnownColor.DarkOliveGreen), 100, "OneHundered"));
            Add(new Line(Color.FromKnownColor(KnownColor.MediumAquamarine), 50, "Fifty"));
            Add(new Line(Color.FromKnownColor(KnownColor.Blue), 0, "Zero"));
            CalculateOnBarClose	= false;
            Overlay				= false;
            PriceTypeSupported	= true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {            
            PctB.Set(((Input[0] - Bollinger(StandardDev, Period).Lower[0]) / (Bollinger(StandardDev, Period).Upper[0] - Bollinger(StandardDev, Period).Lower[0])) * 100);
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries PctB
        {
            get { return Values[0]; }
        }

        [Description("Averaging Period")]
        [Category("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }

        [Description("# of Standard Deviations")]
        [Category("Parameters")]
        public double StandardDev
        {
            get { return standardDev; }
            set { standardDev = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private BollingerPercentB[] cacheBollingerPercentB = null;

        private static BollingerPercentB checkBollingerPercentB = new BollingerPercentB();

        /// <summary>
        /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
        /// </summary>
        /// <returns></returns>
        public BollingerPercentB BollingerPercentB(int period, double standardDev)
        {
            return BollingerPercentB(Input, period, standardDev);
        }

        /// <summary>
        /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
        /// </summary>
        /// <returns></returns>
        public BollingerPercentB BollingerPercentB(Data.IDataSeries input, int period, double standardDev)
        {
            checkBollingerPercentB.Period = period;
            period = checkBollingerPercentB.Period;
            checkBollingerPercentB.StandardDev = standardDev;
            standardDev = checkBollingerPercentB.StandardDev;

            if (cacheBollingerPercentB != null)
                for (int idx = 0; idx < cacheBollingerPercentB.Length; idx++)
                    if (cacheBollingerPercentB[idx].Period == period && Math.Abs(cacheBollingerPercentB[idx].StandardDev - standardDev) <= double.Epsilon && cacheBollingerPercentB[idx].EqualsInput(input))
                        return cacheBollingerPercentB[idx];

            BollingerPercentB indicator = new BollingerPercentB();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Period = period;
            indicator.StandardDev = standardDev;
            indicator.SetUp();

            BollingerPercentB[] tmp = new BollingerPercentB[cacheBollingerPercentB == null ? 1 : cacheBollingerPercentB.Length + 1];
            if (cacheBollingerPercentB != null)
                cacheBollingerPercentB.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheBollingerPercentB = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BollingerPercentB BollingerPercentB(int period, double standardDev)
        {
            return _indicator.BollingerPercentB(Input, period, standardDev);
        }

        /// <summary>
        /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
        /// </summary>
        /// <returns></returns>
        public Indicator.BollingerPercentB BollingerPercentB(Data.IDataSeries input, int period, double standardDev)
        {
            return _indicator.BollingerPercentB(input, period, standardDev);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.BollingerPercentB BollingerPercentB(int period, double standardDev)
        {
            return _indicator.BollingerPercentB(Input, period, standardDev);
        }

        /// <summary>
        /// %b depicts the location of the most recent close price in relation to the Bollinger Bands as well as to what degree it is above or below any of the bands. 
        /// </summary>
        /// <returns></returns>
        public Indicator.BollingerPercentB BollingerPercentB(Data.IDataSeries input, int period, double standardDev)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.BollingerPercentB(input, period, standardDev);
        }

    }
}
#endregion
