#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private Turning_Points_Indicator[] cacheTurning_Points_Indicator;
		private ShortTermSwingsNT8[] cacheShortTermSwingsNT8;

		
		public Turning_Points_Indicator Turning_Points_Indicator(double revsize, int _size, int plotDistance_, Brush upColor, Brush dnColor, Brush colorUp, Brush colorDown, bool paintBars)
		{
			return Turning_Points_Indicator(Input, revsize, _size, plotDistance_, upColor, dnColor, colorUp, colorDown, paintBars);
		}

		public ShortTermSwingsNT8 ShortTermSwingsNT8(Brush colorUp, Brush colorDown, bool paintBars)
		{
			return ShortTermSwingsNT8(Input, colorUp, colorDown, paintBars);
		}


		
		public Turning_Points_Indicator Turning_Points_Indicator(ISeries<double> input, double revsize, int _size, int plotDistance_, Brush upColor, Brush dnColor, Brush colorUp, Brush colorDown, bool paintBars)
		{
			if (cacheTurning_Points_Indicator != null)
				for (int idx = 0; idx < cacheTurning_Points_Indicator.Length; idx++)
					if (cacheTurning_Points_Indicator[idx].Revsize == revsize && cacheTurning_Points_Indicator[idx]._Size == _size && cacheTurning_Points_Indicator[idx].PlotDistance_ == plotDistance_ && cacheTurning_Points_Indicator[idx].UpColor == upColor && cacheTurning_Points_Indicator[idx].DnColor == dnColor && cacheTurning_Points_Indicator[idx].ColorUp == colorUp && cacheTurning_Points_Indicator[idx].ColorDown == colorDown && cacheTurning_Points_Indicator[idx].PaintBars == paintBars && cacheTurning_Points_Indicator[idx].EqualsInput(input))
						return cacheTurning_Points_Indicator[idx];
			return CacheIndicator<Turning_Points_Indicator>(new Turning_Points_Indicator(){ Revsize = revsize, _Size = _size, PlotDistance_ = plotDistance_, UpColor = upColor, DnColor = dnColor, ColorUp = colorUp, ColorDown = colorDown, PaintBars = paintBars }, input, ref cacheTurning_Points_Indicator);
		}

		public ShortTermSwingsNT8 ShortTermSwingsNT8(ISeries<double> input, Brush colorUp, Brush colorDown, bool paintBars)
		{
			if (cacheShortTermSwingsNT8 != null)
				for (int idx = 0; idx < cacheShortTermSwingsNT8.Length; idx++)
					if (cacheShortTermSwingsNT8[idx].ColorUp == colorUp && cacheShortTermSwingsNT8[idx].ColorDown == colorDown && cacheShortTermSwingsNT8[idx].PaintBars == paintBars && cacheShortTermSwingsNT8[idx].EqualsInput(input))
						return cacheShortTermSwingsNT8[idx];
			return CacheIndicator<ShortTermSwingsNT8>(new ShortTermSwingsNT8(){ ColorUp = colorUp, ColorDown = colorDown, PaintBars = paintBars }, input, ref cacheShortTermSwingsNT8);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.Turning_Points_Indicator Turning_Points_Indicator(double revsize, int _size, int plotDistance_, Brush upColor, Brush dnColor, Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.Turning_Points_Indicator(Input, revsize, _size, plotDistance_, upColor, dnColor, colorUp, colorDown, paintBars);
		}

		public Indicators.ShortTermSwingsNT8 ShortTermSwingsNT8(Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.ShortTermSwingsNT8(Input, colorUp, colorDown, paintBars);
		}


		
		public Indicators.Turning_Points_Indicator Turning_Points_Indicator(ISeries<double> input , double revsize, int _size, int plotDistance_, Brush upColor, Brush dnColor, Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.Turning_Points_Indicator(input, revsize, _size, plotDistance_, upColor, dnColor, colorUp, colorDown, paintBars);
		}

		public Indicators.ShortTermSwingsNT8 ShortTermSwingsNT8(ISeries<double> input , Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.ShortTermSwingsNT8(input, colorUp, colorDown, paintBars);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.Turning_Points_Indicator Turning_Points_Indicator(double revsize, int _size, int plotDistance_, Brush upColor, Brush dnColor, Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.Turning_Points_Indicator(Input, revsize, _size, plotDistance_, upColor, dnColor, colorUp, colorDown, paintBars);
		}

		public Indicators.ShortTermSwingsNT8 ShortTermSwingsNT8(Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.ShortTermSwingsNT8(Input, colorUp, colorDown, paintBars);
		}


		
		public Indicators.Turning_Points_Indicator Turning_Points_Indicator(ISeries<double> input , double revsize, int _size, int plotDistance_, Brush upColor, Brush dnColor, Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.Turning_Points_Indicator(input, revsize, _size, plotDistance_, upColor, dnColor, colorUp, colorDown, paintBars);
		}

		public Indicators.ShortTermSwingsNT8 ShortTermSwingsNT8(ISeries<double> input , Brush colorUp, Brush colorDown, bool paintBars)
		{
			return indicator.ShortTermSwingsNT8(input, colorUp, colorDown, paintBars);
		}

	}
}

#endregion
