// 
// Copyright (C) 2007, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//
#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Linear Regression Slope indicator from the article 'Confirming Price Trend' authored by Barbara Star, PhD in the December 2007 issue of S+C
    /// </summary>
    [Description("Linear Regression Slope")]
    public class eLinRegSlope : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int period = 8; // Default setting for Period
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Orange, 2), PlotStyle.Bar, "Slope"));
			Add(new Line(Color.Gray, 0, "Zero Line"));
			Lines[0].Pen.DashStyle = DashStyle.Dash;
			
            CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            LRSlope.Set(Slope(LinReg(Period), Period + 4, 0));
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries LRSlope
        {
            get { return Values[0]; }
        }

        [Description("Numbers of bars used for calculations")]
        [Category("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private eLinRegSlope[] cacheeLinRegSlope = null;

        private static eLinRegSlope checkeLinRegSlope = new eLinRegSlope();

        /// <summary>
        /// Linear Regression Slope
        /// </summary>
        /// <returns></returns>
        public eLinRegSlope eLinRegSlope(int period)
        {
            return eLinRegSlope(Input, period);
        }

        /// <summary>
        /// Linear Regression Slope
        /// </summary>
        /// <returns></returns>
        public eLinRegSlope eLinRegSlope(Data.IDataSeries input, int period)
        {
            if (cacheeLinRegSlope != null)
                for (int idx = 0; idx < cacheeLinRegSlope.Length; idx++)
                    if (cacheeLinRegSlope[idx].Period == period && cacheeLinRegSlope[idx].EqualsInput(input))
                        return cacheeLinRegSlope[idx];

            lock (checkeLinRegSlope)
            {
                checkeLinRegSlope.Period = period;
                period = checkeLinRegSlope.Period;

                if (cacheeLinRegSlope != null)
                    for (int idx = 0; idx < cacheeLinRegSlope.Length; idx++)
                        if (cacheeLinRegSlope[idx].Period == period && cacheeLinRegSlope[idx].EqualsInput(input))
                            return cacheeLinRegSlope[idx];

                eLinRegSlope indicator = new eLinRegSlope();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                eLinRegSlope[] tmp = new eLinRegSlope[cacheeLinRegSlope == null ? 1 : cacheeLinRegSlope.Length + 1];
                if (cacheeLinRegSlope != null)
                    cacheeLinRegSlope.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheeLinRegSlope = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Linear Regression Slope
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.eLinRegSlope eLinRegSlope(int period)
        {
            return _indicator.eLinRegSlope(Input, period);
        }

        /// <summary>
        /// Linear Regression Slope
        /// </summary>
        /// <returns></returns>
        public Indicator.eLinRegSlope eLinRegSlope(Data.IDataSeries input, int period)
        {
            return _indicator.eLinRegSlope(input, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Linear Regression Slope
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.eLinRegSlope eLinRegSlope(int period)
        {
            return _indicator.eLinRegSlope(Input, period);
        }

        /// <summary>
        /// Linear Regression Slope
        /// </summary>
        /// <returns></returns>
        public Indicator.eLinRegSlope eLinRegSlope(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.eLinRegSlope(input, period);
        }
    }
}
#endregion
